<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Biobank LIMS - Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <aside class="bg-blue-800 text-white w-64 min-h-screen">
            <div class="p-4">
                <h1 class="text-xl font-bold">Biobank LIMS</h1>
                <p class="text-sm text-blue-200">Admin Dashboard</p>
            </div>

            <nav class="mt-6">
                <a href="/admin" class="block py-2 px-4 hover:bg-blue-700 <?php echo $_SERVER['REQUEST_URI'] === '/admin' ? 'bg-blue-700' : ''; ?>">Dashboard</a>
                <a href="/admin/storage" class="block py-2 px-4 hover:bg-blue-700 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/storage') === 0 ? 'bg-blue-700' : ''; ?>">Storage Management</a>
                <a href="/admin/billing" class="block py-2 px-4 hover:bg-blue-700 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/billing') === 0 ? 'bg-blue-700' : ''; ?>">Billing</a>
                <a href="/admin/reports" class="block py-2 px-4 hover:bg-blue-700 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/reports') === 0 ? 'bg-blue-700' : ''; ?>">Reports</a>
                <a href="/admin/users" class="block py-2 px-4 hover:bg-blue-700 <?php echo strpos($_SERVER['REQUEST_URI'], '/admin/users') === 0 ? 'bg-blue-700' : ''; ?>">User Management</a>
                <a href="/logout" class="block py-2 px-4 hover:bg-blue-700">Logout</a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 p-6">
            <!-- Header -->
            <header class="bg-white p-4 rounded-lg shadow-md mb-6">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-gray-800">Welcome, <?php echo $_SESSION['user']['name']; ?></h2>
                    <div class="text-sm text-gray-600">
                        <?php echo date('l, F j, Y'); ?>
                    </div>
                </div>
            </header>

            <!-- Content -->
            <?php include $content; ?>
        </main>
    </div>
</body>
</html>
