<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Biobank LIMS - Home</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-blue-600 text-white p-4">
            <div class="container mx-auto flex justify-between items-center">
                <h1 class="text-xl font-bold">Biobank LIMS</h1>
                <div class="space-x-4">
                    <a href="/login" class="hover:text-blue-200">Login</a>
                    <a href="/register" class="hover:text-blue-200">Register</a>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <section class="container mx-auto py-12 px-4">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-bold text-blue-600 mb-4">Welcome to Biobank LIMS</h2>
                <p class="text-lg text-gray-600">A comprehensive biobank management system with advanced billing and storage management.</p>
            </div>

            <!-- Features -->
            <div class="grid md:grid-cols-3 gap-6">
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-semibold text-blue-600 mb-3">Storage Management</h3>
                    <p class="text-gray-600">Manage your biobank storage hierarchy from rooms to individual specimen positions.</p>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-semibold text-blue-600 mb-3">Billing Engine</h3>
                    <p class="text-gray-600">Automatic daily billing calculation with real-time balance tracking.</p>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-semibold text-blue-600 mb-3">Client Portal</h3>
                    <p class="text-gray-600">Secure client access to specimen information and billing details.</p>
                </div>
            </div>
        </section>
    </div>
</body>
</html>
