<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Dispatch Request</h3>

    <form action="/client/dispatch" method="POST" class="space-y-4">
        <div>
            <label for="specimens" class="block text-sm font-medium text-gray-700 mb-1">Select Specimens</label>
            <select id="specimens" name="specimens[]" multiple class="w-full px-3 py-2 border rounded-lg" size="5" required>
                <?php foreach ($specimens as $specimen): ?>
                    <option value="<?php echo $specimen['id']; ?>">
                        <?php echo htmlspecialchars($specimen['barcode'] . ' - ' . $specimen['sample_type']); ?>
                    </option>
                <?php endforeach; ?>
                <?php if (empty($specimens)): ?>
                    <option value="" disabled>No specimens available</option>
                <?php endif; ?>
            </select>
        </div>

        <div>
            <label for="ship_to" class="block text-sm font-medium text-gray-700 mb-1">Ship To Address</label>
            <textarea id="ship_to" name="ship_to" rows="3" class="w-full px-3 py-2 border rounded-lg" required></textarea>
        </div>

        <div>
            <label for="contact_person" class="block text-sm font-medium text-gray-700 mb-1">Contact Person</label>
            <input type="text" id="contact_person" name="contact_person" class="w-full px-3 py-2 border rounded-lg" required>
        </div>

        <div>
            <label for="contact_phone" class="block text-sm font-medium text-gray-700 mb-1">Contact Phone</label>
            <input type="tel" id="contact_phone" name="contact_phone" class="w-full px-3 py-2 border rounded-lg" required>
        </div>

        <div>
            <label for="special_instructions" class="block text-sm font-medium text-gray-700 mb-1">Special Instructions</label>
            <textarea id="special_instructions" name="special_instructions" rows="3" class="w-full px-3 py-2 border rounded-lg"></textarea>
        </div>

        <div class="pt-4">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                Submit Dispatch Request
            </button>
        </div>
    </form>
</div>
