<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
    <!-- Current Balance -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Current Balance</h3>
        <div class="text-center">
            <p class="text-sm text-gray-600 mb-2">Total Accrued Balance</p>
            <p class="text-3xl font-bold text-green-600">$<?php echo number_format($balance['total_balance'], 2); ?></p>
            <p class="text-sm text-gray-500 mt-2">Based on <?php echo count($balance['specimens']); ?> active specimens</p>
        </div>
    </div>

    <!-- Specimen Summary -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Specimen Summary</h3>
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Total Specimens:</span>
                <span class="font-semibold"><?php echo count($specimens); ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Active Specimens:</span>
                <span class="font-semibold text-green-600"><?php echo count($balance['specimens']); ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Oldest Specimen:</span>
                <span class="font-semibold">
                    <?php
                    if (!empty($specimens)) {
                        $oldest = min(array_map(function($s) { return strtotime($s['received_at']); }, $specimens));
                        echo date('M j, Y', $oldest);
                    } else {
                        echo 'N/A';
                    }
                    ?>
                </span>
            </div>
        </div>
    </div>
</div>

<!-- Recent Specimens -->
<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Recent Specimens</h3>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="bg-gray-50">
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Barcode</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Type</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Location</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Received</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach (array_slice($specimens, 0, 5) as $specimen): ?>
                    <tr class="border-t">
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['barcode']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['sample_type']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['box_name'] . ' - ' . $specimen['row_index'] . '-' . $specimen['col_index']); ?></td>
                        <td class="px-4 py-3"><?php echo date('M j, Y', strtotime($specimen['received_at'])); ?></td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs <?php
                                switch ($specimen['status']) {
                                    case 'Stored': echo 'bg-green-100 text-green-800'; break;
                                    case 'Shipped': echo 'bg-blue-100 text-blue-800'; break;
                                    case 'Destroyed': echo 'bg-red-100 text-red-800'; break;
                                }
                            ?>">
                                <?php echo htmlspecialchars($specimen['status']); ?>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($specimens)): ?>
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-gray-500">No specimens found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-4">
        <a href="/client/specimens" class="text-blue-600 hover:text-blue-800">View All Specimens</a>
    </div>
</div>

<!-- Billing Breakdown -->
<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Billing Breakdown</h3>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="bg-gray-50">
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Specimen</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Type</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Days</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Rate</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Cost</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($balance['specimens'] as $specimen): ?>
                    <tr class="border-t">
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['barcode']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['sample_type']); ?></td>
                        <td class="px-4 py-3"><?php echo $specimen['days_stored']; ?></td>
                        <td class="px-4 py-3">$<?php echo number_format($specimen['daily_rate'], 2); ?>/day</td>
                        <td class="px-4 py-3">$<?php echo number_format($specimen['cost'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($balance['specimens'])): ?>
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-gray-500">No active specimens for billing</td>
                    </tr>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-50 font-semibold">
                    <td colspan="4" class="px-4 py-3 text-right">Total:</td>
                    <td class="px-4 py-3">$<?php echo number_format($balance['total_balance'], 2); ?></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
