<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">User Management</h3>

    <!-- Add User Form -->
    <div class="bg-gray-50 p-4 rounded-lg mb-6">
        <h4 class="font-semibold mb-3">Add New User</h4>
        <form action="/admin/users/add" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                <input type="text" id="name" name="name" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                <input type="email" id="email" name="email" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="role" class="block text-sm font-medium text-gray-700 mb-1">Role</label>
                <select id="role" name="role" class="w-full px-3 py-2 border rounded-lg" required>
                    <option value="Admin">Admin</option>
                    <option value="Staff">Staff</option>
                    <option value="Client">Client</option>
                </select>
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                <input type="password" id="password" name="password" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div class="md:col-span-3">
                <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">Add User</button>
            </div>
        </form>
    </div>

    <!-- Users List -->
    <div class="overflow-x-auto">
        <h4 class="font-semibold mb-3">Existing Users</h4>
        <table class="w-full">
            <thead>
                <tr class="bg-gray-50">
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Name</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Email</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Role</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Actions</th>
                </tr>
            </thead>
            <tbody>
                <!-- In a real implementation, this would show actual users from the database -->
                <tr class="border-t">
                    <td class="px-4 py-3">Admin User</td>
                    <td class="px-4 py-3">admin@example.com</td>
                    <td class="px-4 py-3">Admin</td>
                    <td class="px-4 py-3">
                        <button class="text-blue-600 hover:text-blue-800 text-sm">Edit</button>
                        <button class="text-red-600 hover:text-red-800 text-sm ml-2">Delete</button>
                    </td>
                </tr>
                <tr class="border-t">
                    <td class="px-4 py-3">Staff User</td>
                    <td class="px-4 py-3">staff@example.com</td>
                    <td class="px-4 py-3">Staff</td>
                    <td class="px-4 py-3">
                        <button class="text-blue-600 hover:text-blue-800 text-sm">Edit</button>
                        <button class="text-red-600 hover:text-red-800 text-sm ml-2">Delete</button>
                    </td>
                </tr>
                <tr class="border-t">
                    <td class="px-4 py-3">Client User</td>
                    <td class="px-4 py-3">client@example.com</td>
                    <td class="px-4 py-3">Client</td>
                    <td class="px-4 py-3">
                        <button class="text-blue-600 hover:text-blue-800 text-sm">Edit</button>
                        <button class="text-red-600 hover:text-red-800 text-sm ml-2">Delete</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
