<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Reports</h3>

    <!-- Report Filters -->
    <div class="bg-gray-50 p-4 rounded-lg mb-6">
        <h4 class="font-semibold mb-3">Generate Report</h4>
        <form action="/admin/reports/generate" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="report_type" class="block text-sm font-medium text-gray-700 mb-1">Report Type</label>
                <select id="report_type" name="report_type" class="w-full px-3 py-2 border rounded-lg" required>
                    <option value="storage_utilization">Storage Utilization</option>
                    <option value="billing_summary">Billing Summary</option>
                    <option value="specimen_inventory">Specimen Inventory</option>
                    <option value="client_activity">Client Activity</option>
                </select>
            </div>

            <div>
                <label for="date_range" class="block text-sm font-medium text-gray-700 mb-1">Date Range</label>
                <select id="date_range" name="date_range" class="w-full px-3 py-2 border rounded-lg">
                    <option value="last_week">Last Week</option>
                    <option value="last_month">Last Month</option>
                    <option value="last_quarter">Last Quarter</option>
                    <option value="last_year">Last Year</option>
                    <option value="custom">Custom</option>
                </select>
            </div>

            <div>
                <label for="format" class="block text-sm font-medium text-gray-700 mb-1">Format</label>
                <select id="format" name="format" class="w-full px-3 py-2 border rounded-lg">
                    <option value="pdf">PDF</option>
                    <option value="csv">CSV</option>
                    <option value="excel">Excel</option>
                </select>
            </div>

            <div class="md:col-span-3">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">Generate Report</button>
            </div>
        </form>
    </div>
</div>

<!-- Sample Reports -->
<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <!-- Storage Utilization Report -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h4 class="font-semibold mb-4">Storage Utilization Report</h4>
        <canvas id="storageUtilizationChart" width="400" height="200"></canvas>
    </div>

    <!-- Billing Summary Report -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h4 class="font-semibold mb-4">Billing Summary Report</h4>
        <canvas id="billingSummaryChart" width="400" height="200"></canvas>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Storage Utilization Chart
    const storageCtx = document.getElementById('storageUtilizationChart').getContext('2d');
    new Chart(storageCtx, {
        type: 'doughnut',
        data: {
            labels: ['Occupied', 'Empty', 'Reserved'],
            datasets: [{
                data: [65, 30, 5],
                backgroundColor: [
                    'rgba(22, 163, 74, 0.7)',
                    'rgba(59, 130, 246, 0.7)',
                    'rgba(251, 191, 36, 0.7)'
                ],
                borderWidth: 1
            }]
        }
    });

    // Billing Summary Chart
    const billingCtx = document.getElementById('billingSummaryChart').getContext('2d');
    new Chart(billingCtx, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            datasets: [{
                label: 'Revenue',
                data: [1200, 1900, 1500, 2200, 1800, 2500],
                backgroundColor: 'rgba(59, 130, 246, 0.7)',
                borderColor: 'rgba(59, 130, 246, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
});
</script>
