<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Billing Management</h3>

    <!-- Billing Rates -->
    <div class="mb-6">
        <h4 class="font-semibold mb-3">Billing Rates</h4>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="bg-gray-50">
                        <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Sample Type</th>
                        <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Daily Rate</th>
                        <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($billingRates as $rate): ?>
                        <tr class="border-t">
                            <td class="px-4 py-3"><?php echo htmlspecialchars($rate['sample_type']); ?></td>
                            <td class="px-4 py-3">$<?php echo number_format($rate['daily_rate'], 2); ?>/day</td>
                            <td class="px-4 py-3">
                                <button class="text-blue-600 hover:text-blue-800 text-sm" onclick="openEditRateModal('<?php echo $rate['sample_type']; ?>', <?php echo $rate['daily_rate']; ?>)">Edit</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add New Rate -->
    <div class="mb-6">
        <h4 class="font-semibold mb-3">Add New Billing Rate</h4>
        <form action="/admin/billing/add-rate" method="POST" class="flex gap-2">
            <input type="text" name="sample_type" placeholder="Sample Type" class="px-3 py-2 border rounded-lg flex-1" required>
            <input type="number" step="0.01" name="daily_rate" placeholder="Daily Rate" class="px-3 py-2 border rounded-lg" required>
            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">Add Rate</button>
        </form>
    </div>
</div>

<!-- Edit Rate Modal -->
<div id="editRateModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white p-6 rounded-lg shadow-md w-full max-w-md">
        <h3 class="text-lg font-semibold mb-4">Edit Billing Rate</h3>
        <form id="editRateForm" action="/admin/billing/update-rate" method="POST">
            <input type="hidden" id="editSampleType" name="sample_type">
            <div class="mb-4">
                <label for="editDailyRate" class="block text-sm font-medium text-gray-700 mb-1">Daily Rate</label>
                <input type="number" step="0.01" id="editDailyRate" name="daily_rate" class="w-full px-3 py-2 border rounded-lg" required>
            </div>
            <div class="flex gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">Update</button>
                <button type="button" onclick="closeEditRateModal()" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition">Cancel</button>
            </div>
        </form>
    </div>
</div>

<script>
function openEditRateModal(sampleType, dailyRate) {
    document.getElementById('editSampleType').value = sampleType;
    document.getElementById('editDailyRate').value = dailyRate;
    document.getElementById('editRateModal').classList.remove('hidden');
    document.getElementById('editRateModal').classList.add('flex');
}

function closeEditRateModal() {
    document.getElementById('editRateModal').classList.add('hidden');
    document.getElementById('editRateModal').classList.remove('flex');
}
</script>
