<?php
namespace Controllers;

use Services\StorageService;
use Services\BillingService;

class ClientSpecimensController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'Client') {
            header('Location: /login');
            exit;
        }

        // Get client specimens
        $specimens = StorageService::getClientSpecimens($_SESSION['user']['client_id']);

        // Calculate client balance
        $balance = BillingService::calculateClientBalance($_SESSION['user']['client_id']);

        // Include view
        $content = __DIR__ . '/../views/client/specimens.php';
        include __DIR__ . '/../views/layouts/client.php';
    }
}
