<?php
namespace Controllers;

use Services\AuthService;

class AdminUsersController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        // In a real implementation, this would get users from the database
        // For this demo, we'll just show the static view

        // Include view
        $content = __DIR__ . '/../views/admin/users.php';
        include __DIR__ . '/../views/layouts/admin.php';
    }

    public function add() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $name = $_POST['name'] ?? '';
            $email = $_POST['email'] ?? '';
            $password = $_POST['password'] ?? '';
            $role = $_POST['role'] ?? 'Client';

            try {
                AuthService::registerUser($name, $email, $password, $role);
                $_SESSION['success'] = 'User added successfully!';
                header('Location: /admin/users');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /admin/users');
                exit;
            }
        }
    }
}
