<?php
namespace Controllers;

use Services\StorageService;
use Services\BillingService;

class AdminStorageController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        // Get billing rates for the form
        $billingRates = BillingService::getBillingRates();

        // Include view
        $content = __DIR__ . '/../views/admin/storage.php';
        include __DIR__ . '/../views/layouts/admin.php';
    }
}
