<?php
namespace Controllers;

class AdminReportsController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        // Include view
        $content = __DIR__ . '/../views/admin/reports.php';
        include __DIR__ . '/../views/layouts/admin.php';
    }

    public function generate() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $reportType = $_POST['report_type'] ?? '';
            $dateRange = $_POST['date_range'] ?? '';
            $format = $_POST['format'] ?? '';

            // In a real implementation, this would generate the actual report
            // For this demo, we'll just show a success message

            $_SESSION['success'] = 'Report generation initiated. You will receive an email when the report is ready.';
            header('Location: /admin/reports');
            exit;
        }
    }
}
