<?php
namespace Controllers;

use Services\BillingService;
use Services\StorageService;

class AdminController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        // Get billing statistics
        $billingRates = BillingService::getBillingRates();

        // Get storage statistics
        $storageHierarchy = StorageService::getStorageHierarchy();

        // Calculate storage statistics
        $totalRooms = 0;
        $totalStorageUnits = 0;
        $totalBoxes = 0;
        $occupiedPositions = 0;
        $emptyPositions = 0;

        $rooms = [];
        foreach ($storageHierarchy as $item) {
            if ($item['room_id'] && !isset($rooms[$item['room_id']])) {
                $rooms[$item['room_id']] = [
                    'name' => $item['room_name'],
                    'storage_units' => 0,
                    'boxes' => 0,
                    'positions' => 0,
                    'occupied' => 0
                ];
                $totalRooms++;
            }

            if ($item['storage_unit_id'] && isset($rooms[$item['room_id']])) {
                $rooms[$item['room_id']]['storage_units']++;
                $totalStorageUnits++;
            }

            if ($item['box_id'] && isset($rooms[$item['room_id']])) {
                $rooms[$item['room_id']]['boxes']++;
                $totalBoxes++;
            }

            if ($item['position_id']) {
                $rooms[$item['room_id']]['positions']++;
                if ($item['status'] === 'occupied') {
                    $rooms[$item['room_id']]['occupied']++;
                    $occupiedPositions++;
                } elseif ($item['status'] === 'empty') {
                    $emptyPositions++;
                }
            }
        }

        // Include view
        $content = __DIR__ . '/../views/admin/dashboard.php';
        include __DIR__ . '/../views/layouts/admin.php';
    }
}
