<?php
namespace Controllers;

use Services\BillingService;

class AdminBillingController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        // Get billing rates
        $billingRates = BillingService::getBillingRates();

        // Include view
        $content = __DIR__ . '/../views/admin/billing.php';
        include __DIR__ . '/../views/layouts/admin.php';
    }

    public function addRate() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $sampleType = $_POST['sample_type'] ?? '';
            $dailyRate = $_POST['daily_rate'] ?? null;

            try {
                // In a real implementation, this would add a new billing rate
                // For this demo, we'll just show a success message
                $_SESSION['success'] = 'Billing rate added successfully!';
                header('Location: /admin/billing');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /admin/billing');
                exit;
            }
        }
    }

    public function updateRate() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $sampleType = $_POST['sample_type'] ?? '';
            $dailyRate = $_POST['daily_rate'] ?? null;

            try {
                BillingService::updateBillingRate($sampleType, $dailyRate);
                $_SESSION['success'] = 'Billing rate updated successfully!';
                header('Location: /admin/billing');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /admin/billing');
                exit;
            }
        }
    }
}
